/*
 * Decompiled with CFR 0.152.
 */
package com.cabal.launcher.service;

import com.cabal.launcher.model.Manifest;
import com.cabal.launcher.model.ManifestEntry;
import com.cabal.launcher.service.FileProgressCallback;
import com.cabal.launcher.util.FileVerifier;
import com.cabal.launcher.util.JsonUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.SwingWorker;

public class UpdateManager {
    private static final String BASE_URL = "https://update.cabalmax.com/";
    private static final String UPDATE_MANIFEST_URL = "https://update.cabalmax.com/manifest.json";
    private static final String FULL_MANIFEST_URL = "https://update.cabalmax.com/full-manifest.json";
    private static final String CLIENT_FOLDER = "client/";
    private static final String UPDATE_FOLDER = "update/";
    private static final String GAME_DIRECTORY = ".";
    private static final String LOCAL_MANIFEST_PATH = "./manifest.json";
    private boolean isCancelled = false;

    public List<ManifestEntry> checkForUpdates(Consumer<Integer> progressCallback, Consumer<String> statusCallback, FileProgressCallback fileProgressCallback) throws Exception {
        this.isCancelled = false;
        statusCallback.accept("Downloading latest manifest...");
        progressCallback.accept(5);
        File tempManifestFile = new File("manifest_temp.json");
        try {
            this.downloadFile(UPDATE_MANIFEST_URL, tempManifestFile, bytes -> {});
        }
        catch (IOException e) {
            statusCallback.accept("Failed to download manifest: " + e.getMessage());
            throw e;
        }
        Manifest serverManifest = JsonUtil.loadManifestWithVersion(tempManifestFile);
        progressCallback.accept(10);
        statusCallback.accept("Checking local version...");
        File localManifestFile = new File(LOCAL_MANIFEST_PATH);
        Manifest localManifest = JsonUtil.loadManifestWithVersion(localManifestFile);
        progressCallback.accept(15);
        String serverVersion = serverManifest.getVersion();
        String localVersion = localManifest.getVersion();
        System.out.println("[DEBUG] ========================================");
        System.out.println("[DEBUG] Version Comparison:");
        System.out.println("[DEBUG] Server version: " + serverVersion);
        System.out.println("[DEBUG] Local version: " + localVersion);
        System.out.println("[DEBUG] Versions equal: " + serverVersion.equals(localVersion));
        System.out.println("[DEBUG] ========================================");
        statusCallback.accept("Server version: " + serverVersion + " | Local version: " + localVersion);
        ArrayList<ManifestEntry> filesToUpdate = new ArrayList<ManifestEntry>();
        if (serverVersion.equals(localVersion)) {
            statusCallback.accept("You have the latest version. No updates needed.");
            progressCallback.accept(100);
            tempManifestFile.delete();
            return filesToUpdate;
        }
        statusCallback.accept("New version detected! Checking files...");
        HashMap<String, ManifestEntry> localFilesMap = new HashMap<String, ManifestEntry>();
        for (ManifestEntry entry : localManifest.getFiles()) {
            localFilesMap.put(entry.getPath(), entry);
        }
        List<ManifestEntry> serverFiles = serverManifest.getFiles();
        int totalFiles = serverFiles.size();
        for (int i = 0; i < totalFiles && !this.isCancelled; ++i) {
            ManifestEntry serverEntry = serverFiles.get(i);
            File localFile = new File(GAME_DIRECTORY, serverEntry.getPath());
            boolean needsUpdate = false;
            Object updateReason = "";
            if (!localFile.exists()) {
                needsUpdate = true;
                updateReason = "File doesn't exist";
            } else {
                ManifestEntry localEntry = (ManifestEntry)localFilesMap.get(serverEntry.getPath());
                if (localEntry == null) {
                    needsUpdate = true;
                    updateReason = "New file (not in local manifest)";
                } else if (!localEntry.getHash().equals(serverEntry.getHash())) {
                    needsUpdate = true;
                    updateReason = "Hash differs (local: " + localEntry.getHash().substring(0, 8) + "... server: " + serverEntry.getHash().substring(0, 8) + "...)";
                } else if (!FileVerifier.verifyFile(localFile, serverEntry.getHash())) {
                    needsUpdate = true;
                    updateReason = "File corrupted (hash mismatch on disk)";
                }
            }
            if (needsUpdate) {
                filesToUpdate.add(serverEntry);
                if (i < 10) {
                    System.out.println("[DEBUG] File needs update: " + serverEntry.getPath() + " - " + (String)updateReason);
                }
            }
            int progress = 15 + (int)((float)(i + 1) / (float)totalFiles * 85.0f);
            progressCallback.accept(progress);
            if (fileProgressCallback == null) continue;
            fileProgressCallback.onFileProgress(i + 1, totalFiles, serverEntry.getPath());
        }
        System.out.println("[DEBUG] ========================================");
        System.out.println("[DEBUG] Files to update: " + filesToUpdate.size() + " / " + totalFiles);
        System.out.println("[DEBUG] ========================================");
        String message = filesToUpdate.isEmpty() ? "All files are up to date!" : filesToUpdate.size() + " file(s) need updating";
        statusCallback.accept(message);
        progressCallback.accept(100);
        return filesToUpdate;
    }

    @Deprecated
    public List<ManifestEntry> checkForUpdates(Consumer<Integer> progressCallback, Consumer<String> statusCallback) throws Exception {
        return this.checkForUpdates(progressCallback, statusCallback, null);
    }

    public void downloadFiles(List<ManifestEntry> filesToUpdate, Consumer<Integer> progressCallback, Consumer<String> statusCallback, Consumer<Long> bytesCallback, FileProgressCallback fileProgressCallback, Runnable updateSuccessCallback) throws Exception {
        this.isCancelled = false;
        long totalBytes = 0L;
        for (ManifestEntry entry : filesToUpdate) {
            totalBytes += entry.getSize();
        }
        long downloadedBytes = 0L;
        bytesCallback.accept(totalBytes);
        int totalFiles = filesToUpdate.size();
        try {
            for (int i = 0; i < filesToUpdate.size(); ++i) {
                if (this.isCancelled) {
                    statusCallback.accept("Download cancelled - removing local manifest");
                    File localManifest = new File(LOCAL_MANIFEST_PATH);
                    if (localManifest.exists()) {
                        localManifest.delete();
                    }
                    return;
                }
                ManifestEntry entry = filesToUpdate.get(i);
                int currentFileIndex = i + 1;
                if (fileProgressCallback != null) {
                    fileProgressCallback.onFileProgress(currentFileIndex, totalFiles, entry.getPath());
                }
                statusCallback.accept("Downloading (" + currentFileIndex + "/" + totalFiles + "): " + entry.getPath());
                File tempFile = new File("./temp_download_" + System.currentTimeMillis() + ".tmp");
                System.out.println("[DEBUG] Created temp file path: " + tempFile.getAbsolutePath());
                try {
                    File parentDir;
                    String fileUrl = "https://update.cabalmax.com/update/" + entry.getPath();
                    System.out.println("[DEBUG] Downloading from: " + fileUrl);
                    System.out.println("[DEBUG] Saving to temp: " + tempFile.getAbsolutePath());
                    this.downloadFile(fileUrl, tempFile, bytes -> {});
                    System.out.println("[DEBUG] Download completed. File exists: " + tempFile.exists() + ", Size: " + tempFile.length() + " bytes");
                    if (!tempFile.exists() || tempFile.length() == 0L) {
                        throw new IOException("Download failed - file is missing or empty: " + entry.getPath());
                    }
                    String expectedHash = entry.getHash();
                    System.out.println("[DEBUG] Expected hash: " + expectedHash);
                    String actualHash = null;
                    try {
                        actualHash = FileVerifier.calculateSHA256(tempFile);
                        System.out.println("[DEBUG] Actual hash:   " + actualHash);
                    }
                    catch (IOException e) {
                        throw new IOException("Failed to calculate hash for: " + entry.getPath() + " - " + e.getMessage());
                    }
                    if (!actualHash.equalsIgnoreCase(expectedHash)) {
                        String errorMsg = String.format("Hash verification failed for: %s%n  Expected: %s%n  Actual:   %s%n  File size: %d bytes%n  Temp file: %s", entry.getPath(), expectedHash, actualHash, tempFile.length(), tempFile.getAbsolutePath());
                        throw new IOException(errorMsg);
                    }
                    File targetFile = new File(GAME_DIRECTORY, entry.getPath());
                    Path targetPath = targetFile.toPath().normalize();
                    System.out.println("[DEBUG] Entry path: " + entry.getPath());
                    System.out.println("[DEBUG] Target path normalized: " + targetPath.toString());
                    System.out.println("[DEBUG] Target path absolute: " + String.valueOf(targetPath.toAbsolutePath()));
                    File file = parentDir = targetPath.getParent() != null ? targetPath.getParent().toFile() : null;
                    if (parentDir != null && !parentDir.exists()) {
                        System.out.println("[DEBUG] Creating directories: " + parentDir.getAbsolutePath());
                        if (!parentDir.mkdirs()) {
                            throw new IOException("Failed to create directories: " + parentDir.getAbsolutePath());
                        }
                    }
                    System.out.println("[DEBUG] Moving to target: " + String.valueOf(targetPath.toAbsolutePath()));
                    FileVerifier.atomicReplace(tempFile.toPath(), targetPath);
                    System.out.println("[DEBUG] File moved successfully. Temp file deleted: " + !tempFile.exists());
                    int progress = (int)((float)(downloadedBytes += entry.getSize()) / (float)totalBytes * 100.0f);
                    progressCallback.accept(progress);
                    continue;
                }
                catch (Exception e) {
                    System.err.println("[ERROR] Exception during download: " + e.getMessage());
                    e.printStackTrace();
                    if (tempFile.exists()) {
                        System.out.println("[DEBUG] Cleaning up temp file: " + tempFile.getAbsolutePath());
                        tempFile.delete();
                    }
                    throw e;
                }
            }
            System.out.println("[DEBUG] ========================================");
            System.out.println("[DEBUG] All files downloaded successfully!");
            System.out.println("[DEBUG] Invoking success callback...");
            System.out.println("[DEBUG] ========================================");
            statusCallback.accept("Update completed - updating manifest");
            if (updateSuccessCallback != null) {
                System.out.println("[DEBUG] Success callback is not null, calling run()...");
                updateSuccessCallback.run();
                System.out.println("[DEBUG] Success callback completed!");
            } else {
                System.err.println("[ERROR] Success callback is NULL!");
            }
            statusCallback.accept("Update completed successfully");
        }
        catch (Exception e) {
            System.err.println("[ERROR] Exception in downloadFiles: " + e.getMessage());
            e.printStackTrace();
            statusCallback.accept("Download failed - removing local manifest");
            File localManifest = new File(LOCAL_MANIFEST_PATH);
            if (localManifest.exists()) {
                localManifest.delete();
            }
            throw e;
        }
    }

    public void repair(final Consumer<Integer> progressCallback, final Consumer<String> statusCallback, final FileProgressCallback fileProgressCallback) {
        SwingWorker<Void, Integer> worker = new SwingWorker<Void, Integer>(){

            @Override
            protected Void doInBackground() throws Exception {
                try {
                    statusCallback.accept("Downloading full manifest...");
                    File fullManifestFile = UpdateManager.this.downloadManifest(UpdateManager.FULL_MANIFEST_URL, "./full-manifest.json");
                    List<ManifestEntry> fullManifest = JsonUtil.loadManifest(fullManifestFile);
                    statusCallback.accept("Checking file integrity...");
                    ArrayList<ManifestEntry> corruptedFiles = new ArrayList<ManifestEntry>();
                    int totalFiles = fullManifest.size();
                    for (int i = 0; i < totalFiles && !UpdateManager.this.isCancelled; ++i) {
                        ManifestEntry entry = fullManifest.get(i);
                        File localFile = new File(UpdateManager.GAME_DIRECTORY, entry.getPath());
                        if (!FileVerifier.verifyFile(localFile, entry.getHash())) {
                            corruptedFiles.add(entry);
                        }
                        int progress = (int)((float)(i + 1) / (float)totalFiles * 50.0f);
                        this.publish(progress);
                    }
                    if (corruptedFiles.isEmpty()) {
                        statusCallback.accept("All files are valid. No repair needed.");
                        this.publish(100);
                    } else {
                        statusCallback.accept("Found " + corruptedFiles.size() + " corrupted files. Repairing...");
                        long totalBytes = 0L;
                        for (ManifestEntry entry : corruptedFiles) {
                            totalBytes += entry.getSize();
                        }
                        long downloadedBytes = 0L;
                        int totalFilesToRepair = corruptedFiles.size();
                        for (int i = 0; i < corruptedFiles.size() && !UpdateManager.this.isCancelled; ++i) {
                            ManifestEntry entry = (ManifestEntry)corruptedFiles.get(i);
                            int currentFileIndex = i + 1;
                            if (fileProgressCallback != null) {
                                fileProgressCallback.onFileProgress(currentFileIndex, totalFilesToRepair, entry.getPath());
                            }
                            statusCallback.accept("Repairing (" + currentFileIndex + "/" + totalFilesToRepair + "): " + entry.getPath());
                            File tempFile = new File("./temp_repair_" + System.currentTimeMillis() + ".tmp");
                            try {
                                String fileUrl = "https://update.cabalmax.com/client/" + entry.getPath();
                                UpdateManager.this.downloadFile(fileUrl, tempFile, bytes -> {});
                                if (!FileVerifier.verifyFile(tempFile, entry.getHash())) {
                                    throw new IOException("Hash verification failed for: " + entry.getPath());
                                }
                                File targetFile = new File(UpdateManager.GAME_DIRECTORY, entry.getPath());
                                Path targetPath = targetFile.toPath().normalize();
                                File parentDir = targetFile.getParentFile();
                                if (parentDir != null && !parentDir.exists()) {
                                    System.out.println("[DEBUG] Creating directories for repair: " + parentDir.getAbsolutePath());
                                    if (!parentDir.mkdirs()) {
                                        throw new IOException("Failed to create directories: " + parentDir.getAbsolutePath());
                                    }
                                }
                                FileVerifier.atomicReplace(tempFile.toPath(), targetPath);
                                int progress = 50 + (int)((float)(downloadedBytes += entry.getSize()) / (float)totalBytes * 50.0f);
                                this.publish(progress);
                                continue;
                            }
                            catch (Exception e) {
                                if (tempFile.exists()) {
                                    tempFile.delete();
                                }
                                throw e;
                            }
                        }
                        statusCallback.accept("Repair completed. " + corruptedFiles.size() + " files restored.");
                    }
                }
                catch (Exception e) {
                    statusCallback.accept("Repair failed: " + e.getMessage());
                    e.printStackTrace();
                }
                return null;
            }

            @Override
            protected void process(List<Integer> chunks) {
                if (!chunks.isEmpty()) {
                    progressCallback.accept(chunks.get(chunks.size() - 1));
                }
            }
        };
        worker.execute();
    }

    public void cancel() {
        this.isCancelled = true;
    }

    private File downloadManifest(String manifestUrl, String localPath) throws IOException {
        File manifestFile = new File(localPath);
        try {
            this.downloadFile(manifestUrl, manifestFile, bytes -> {});
        }
        catch (IOException e) {
            System.err.println("Failed to download manifest from " + manifestUrl + ": " + e.getMessage());
        }
        return manifestFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadFile(String urlString, File outputFile, Consumer<Long> progressCallback) throws IOException {
        URL url = new URL(urlString);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.setConnectTimeout(10000);
        connection.setReadTimeout(30000);
        int responseCode = connection.getResponseCode();
        if (responseCode != 200) {
            connection.disconnect();
            throw new IOException("Server returned HTTP " + responseCode + " for: " + urlString);
        }
        long contentLength = connection.getContentLengthLong();
        if (contentLength == 0L) {
            connection.disconnect();
            throw new IOException("Server returned empty file (0 bytes) for: " + urlString);
        }
        try (InputStream in = connection.getInputStream();
             FileOutputStream out = new FileOutputStream(outputFile);){
            int bytesRead;
            byte[] buffer = new byte[8192];
            long totalRead = 0L;
            while ((bytesRead = in.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
                progressCallback.accept(totalRead += (long)bytesRead);
            }
            if (contentLength > 0L && totalRead != contentLength) {
                throw new IOException("Download incomplete: got " + totalRead + " bytes, expected " + contentLength);
            }
        }
        finally {
            connection.disconnect();
        }
    }
}

