/*
 * Decompiled with CFR 0.152.
 */
package com.cabal.launcher.ui;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.RoundRectangle2D;
import java.net.URI;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.plaf.basic.BasicButtonUI;

public class BannerPanel
extends JPanel {
    private static final Color BG_COLOR = new Color(28, 31, 38);
    private static final Color NAV_BAR_COLOR = new Color(20, 23, 28);
    private static final Color LINK_COLOR = new Color(255, 255, 255);
    private static final Color LINK_HOVER_COLOR = new Color(218, 165, 32);
    private Image currentImage;
    private float alpha = 0.0f;
    private Timer fadeTimer;
    private JPanel contentPanel;

    public BannerPanel() {
        this.setLayout(new BorderLayout());
        this.setBackground(BG_COLOR);
        this.setPreferredSize(new Dimension(800, 450));
        JPanel navBar = this.createNavigationBar();
        this.add((Component)navBar, "North");
        final BannerPanel self = this;
        this.contentPanel = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                self.paintBannerContent(g);
            }
        };
        this.contentPanel.setBackground(BG_COLOR);
        this.add((Component)this.contentPanel, "Center");
        this.loadBannerImage();
    }

    private void loadBannerImage() {
        try {
            URL imageURL = this.getClass().getResource("/assets/images/banner.jpg");
            if (imageURL != null) {
                ImageIcon icon = new ImageIcon(imageURL);
                if (icon.getIconWidth() > 0) {
                    this.setBannerImage(icon.getImage());
                } else {
                    this.setPlaceholderBanner();
                }
            } else {
                System.out.println("Banner image not found, using placeholder");
                this.setPlaceholderBanner();
            }
        }
        catch (Exception e) {
            System.err.println("Error loading banner image: " + e.getMessage());
            e.printStackTrace();
            this.setPlaceholderBanner();
        }
    }

    private JPanel createNavigationBar() {
        String[][] menuItems;
        JPanel navBar = new JPanel(new BorderLayout());
        navBar.setBackground(NAV_BAR_COLOR);
        navBar.setPreferredSize(new Dimension(800, 50));
        navBar.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 20));
        JPanel logoPanel = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                Graphics2D g2d = (Graphics2D)g.create();
                g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                Font logoFont = new Font("Arial", 1, 20);
                g2d.setFont(logoFont);
                int x = 5;
                int y = 30;
                g2d.setColor(Color.RED);
                g2d.drawString("CABAL", x, y);
                FontMetrics fm = g2d.getFontMetrics();
                int cabalWidth = fm.stringWidth("CABAL ");
                g2d.setColor(Color.WHITE);
                g2d.drawString("MAX", x + cabalWidth, y);
                g2d.dispose();
            }
        };
        logoPanel.setBackground(NAV_BAR_COLOR);
        logoPanel.setPreferredSize(new Dimension(150, 50));
        navBar.add((Component)logoPanel, "West");
        JPanel linksPanel = new JPanel(new FlowLayout(2, 15, 10));
        linksPanel.setBackground(NAV_BAR_COLOR);
        for (String[] item : menuItems = new String[][]{{"HOME", "https://cabalmax.com/"}, {"DOWNLOAD", "https://cabalmax.com/download"}, {"RANKINGS", "https://cabalmax.com/rankings"}, {"UPDATES", "https://cabalmax.com/updates"}, {"DISCORD", "https://cabalmax.com/discord"}}) {
            JButton linkButton = this.createNavLink(item[0], item[1]);
            linksPanel.add(linkButton);
        }
        JButton loginBtn = this.createSpecialButton("LOGIN", "https://cabalmax.com/login", false);
        JButton registerBtn = this.createSpecialButton("REGISTER", "https://cabalmax.com/register", true);
        linksPanel.add(Box.createHorizontalStrut(10));
        linksPanel.add(loginBtn);
        linksPanel.add(registerBtn);
        navBar.add((Component)linksPanel, "East");
        return navBar;
    }

    private JButton createNavLink(String text, final String url) {
        final JButton button = new JButton(text);
        button.setForeground(LINK_COLOR);
        button.setFont(new Font("Arial", 1, 12));
        button.setBackground(NAV_BAR_COLOR);
        button.setBorderPainted(false);
        button.setFocusPainted(false);
        button.setContentAreaFilled(false);
        button.setCursor(new Cursor(12));
        button.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                button.setForeground(LINK_HOVER_COLOR);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                button.setForeground(LINK_COLOR);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                BannerPanel.this.openWebPage(url);
            }
        });
        return button;
    }

    private JButton createSpecialButton(String text, String url, boolean isPrimary) {
        JButton button = new JButton(text);
        button.setFont(new Font("Arial", 1, 14));
        button.setFocusPainted(false);
        button.setCursor(new Cursor(12));
        button.setContentAreaFilled(false);
        button.setOpaque(false);
        if (isPrimary) {
            button.setForeground(Color.BLACK);
            final Color orangeBorder = new Color(245, 158, 11);
            button.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(orangeBorder, 2), BorderFactory.createEmptyBorder(8, 20, 8, 20)));
            button.setUI(new BasicButtonUI(this){

                @Override
                public void paint(Graphics g, JComponent c) {
                    JButton btn = (JButton)c;
                    Graphics2D g2d = (Graphics2D)g.create();
                    g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    Color gold = new Color(251, 191, 36);
                    Color orange = new Color(245, 158, 11);
                    GradientPaint gradient = new GradientPaint(0.0f, 0.0f, gold, btn.getWidth(), btn.getHeight(), orange);
                    g2d.setPaint(gradient);
                    g2d.fillRoundRect(0, 0, btn.getWidth(), btn.getHeight(), 4, 4);
                    g2d.setColor(orangeBorder);
                    g2d.setStroke(new BasicStroke(2.0f));
                    g2d.drawRoundRect(1, 1, btn.getWidth() - 2, btn.getHeight() - 2, 4, 4);
                    g2d.dispose();
                    super.paint(g, c);
                }
            });
        } else {
            final Color goldColor = new Color(251, 191, 36);
            button.setForeground(goldColor);
            button.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(goldColor, 2), BorderFactory.createEmptyBorder(8, 20, 8, 20)));
            button.setUI(new BasicButtonUI(this){

                @Override
                public void paint(Graphics g, JComponent c) {
                    JButton btn = (JButton)c;
                    Graphics2D g2d = (Graphics2D)g.create();
                    g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    if (btn.getModel().isRollover()) {
                        g2d.setColor(new Color(251, 191, 36, 40));
                    } else {
                        g2d.setColor(new Color(251, 191, 36, 26));
                    }
                    g2d.fillRoundRect(0, 0, btn.getWidth(), btn.getHeight(), 4, 4);
                    if (btn.getModel().isRollover()) {
                        g2d.setColor(new Color(252, 200, 50));
                    } else {
                        g2d.setColor(goldColor);
                    }
                    g2d.setStroke(new BasicStroke(2.0f));
                    g2d.drawRoundRect(1, 1, btn.getWidth() - 2, btn.getHeight() - 2, 4, 4);
                    g2d.dispose();
                    super.paint(g, c);
                }
            });
        }
        button.addActionListener(e -> this.openWebPage(url));
        return button;
    }

    private void openWebPage(String url) {
        try {
            Desktop desktop;
            Desktop desktop2 = desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
            if (desktop != null && desktop.isSupported(Desktop.Action.BROWSE)) {
                desktop.browse(new URI(url));
            } else {
                JOptionPane.showMessageDialog(this, "Please visit: " + url, "Open Browser", 1);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(this, "Could not open browser: " + ex.getMessage(), "Error", 0);
        }
    }

    public void setBannerImage(Image image) {
        if (this.fadeTimer != null && this.fadeTimer.isRunning()) {
            this.fadeTimer.stop();
        }
        this.currentImage = image;
        this.alpha = 0.0f;
        this.fadeTimer = new Timer(30, e -> {
            this.alpha += 0.05f;
            if (this.alpha >= 1.0f) {
                this.alpha = 1.0f;
                this.fadeTimer.stop();
            }
            this.contentPanel.repaint();
        });
        this.fadeTimer.start();
    }

    private void setPlaceholderBanner() {
        this.currentImage = null;
        this.alpha = 1.0f;
    }

    private void paintBannerContent(Graphics g) {
        int margin;
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        int imageX = margin = 2;
        int imageY = margin;
        int imageWidth = this.contentPanel.getWidth() - margin * 2;
        int imageHeight = this.contentPanel.getHeight() - margin * 2;
        if (this.currentImage != null) {
            Composite oldComposite = g2d.getComposite();
            g2d.setComposite(AlphaComposite.getInstance(3, this.alpha));
            g2d.drawImage(this.currentImage, imageX, imageY, imageWidth, imageHeight, this.contentPanel);
            g2d.setComposite(oldComposite);
        } else {
            GradientPaint gradient = new GradientPaint(imageX, imageY, new Color(20, 30, 48), imageX + imageWidth, imageY + imageHeight, new Color(40, 50, 68));
            g2d.setPaint(gradient);
            g2d.fill(new RoundRectangle2D.Float(imageX, imageY, imageWidth, imageHeight, 15.0f, 15.0f));
            g2d.setColor(new Color(218, 165, 32));
            g2d.setFont(new Font("Arial", 1, 36));
            String text = "CABAL MAX";
            FontMetrics fm = g2d.getFontMetrics();
            int x = (this.contentPanel.getWidth() - fm.stringWidth(text)) / 2;
            int y = (this.contentPanel.getHeight() + fm.getAscent()) / 2;
            g2d.drawString(text, x, y);
            g2d.setColor(Color.WHITE);
            g2d.setFont(new Font("Arial", 0, 18));
            String subtitle = "Epic MMORPG Adventure";
            fm = g2d.getFontMetrics();
            x = (this.contentPanel.getWidth() - fm.stringWidth(subtitle)) / 2;
            g2d.drawString(subtitle, x, y += 40);
        }
        g2d.dispose();
    }
}

