/*
 * Decompiled with CFR 0.152.
 */
package com.cabal.launcher.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class CustomTitleBar
extends JPanel {
    private static final Color BG_COLOR = new Color(28, 31, 38);
    private static final Color BUTTON_HOVER = new Color(51, 136, 255);
    private static final Color TEXT_COLOR = new Color(218, 165, 32);
    private Point initialClick;
    private final JFrame parentFrame;

    public CustomTitleBar(final JFrame parentFrame) {
        this.parentFrame = parentFrame;
        this.setLayout(new BorderLayout());
        this.setBackground(BG_COLOR);
        this.setPreferredSize(new Dimension(0, 40));
        JLabel titleLabel = new JLabel("CABAL MAX LAUNCHER");
        titleLabel.setForeground(TEXT_COLOR);
        titleLabel.setFont(new Font("Arial", 1, 14));
        titleLabel.setBorder(BorderFactory.createEmptyBorder(0, 15, 0, 0));
        this.add((Component)titleLabel, "West");
        JPanel buttonPanel = new JPanel(new FlowLayout(2, 0, 0));
        buttonPanel.setOpaque(false);
        JButton minimizeBtn = this.createTitleBarButton("Minimize");
        minimizeBtn.addActionListener(e -> parentFrame.setState(1));
        buttonPanel.add(minimizeBtn);
        JButton closeBtn = this.createTitleBarButton("Close");
        closeBtn.addActionListener(e -> System.exit(0));
        buttonPanel.add(closeBtn);
        this.add((Component)buttonPanel, "East");
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                CustomTitleBar.this.initialClick = e.getPoint();
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (CustomTitleBar.this.initialClick != null) {
                    int x = parentFrame.getLocation().x + e.getX() - CustomTitleBar.this.initialClick.x;
                    int y = parentFrame.getLocation().y + e.getY() - CustomTitleBar.this.initialClick.y;
                    parentFrame.setLocation(x, y);
                }
            }
        });
    }

    private JButton createTitleBarButton(String text) {
        final JButton button = new JButton(text);
        button.setPreferredSize(new Dimension(45, 40));
        button.setForeground(Color.WHITE);
        button.setBackground(BG_COLOR);
        button.setFont(new Font("Arial", 0, 20));
        button.setBorder(BorderFactory.createEmptyBorder());
        button.setFocusPainted(false);
        button.setCursor(new Cursor(12));
        button.addMouseListener(new MouseAdapter(this){

            @Override
            public void mouseEntered(MouseEvent e) {
                button.setBackground(BUTTON_HOVER);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                button.setBackground(BG_COLOR);
            }
        });
        return button;
    }
}

