/*
 * Decompiled with CFR 0.152.
 */
package com.cabal.launcher.ui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JComponent;
import javax.swing.JProgressBar;
import javax.swing.plaf.basic.BasicProgressBarUI;

public class GlassyProgressBar
extends JProgressBar {
    private static final Color TRACK_COLOR = new Color(40, 43, 50);
    private static final Color PROGRESS_START = new Color(10, 97, 255);
    private static final Color PROGRESS_END = new Color(51, 136, 255);

    public GlassyProgressBar(int min, int max) {
        super(min, max);
        this.setupProgressBar();
    }

    private void setupProgressBar() {
        this.setStringPainted(false);
        this.setBorderPainted(false);
        this.setOpaque(false);
        this.setUI(new BasicProgressBarUI(){

            @Override
            protected void paintDeterminate(Graphics g, JComponent c) {
                Graphics2D g2d = (Graphics2D)g.create();
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                int width = GlassyProgressBar.this.getWidth();
                int height = GlassyProgressBar.this.getHeight();
                int arc = 8;
                g2d.setColor(TRACK_COLOR);
                g2d.fillRoundRect(0, 0, width, height, arc, arc);
                GradientPaint trackShadow = new GradientPaint(0.0f, 0.0f, new Color(0, 0, 0, 60), 0.0f, height / 2, new Color(0, 0, 0, 0));
                g2d.setPaint(trackShadow);
                g2d.fillRoundRect(0, 0, width, height / 2, arc, arc);
                int progressWidth = (int)((double)(width - 2) * ((double)GlassyProgressBar.this.getValue() / (double)GlassyProgressBar.this.getMaximum()));
                if (progressWidth > 0) {
                    RoundRectangle2D.Float progressClip = new RoundRectangle2D.Float(1.0f, 1.0f, progressWidth, height - 2, arc - 2, arc - 2);
                    g2d.setClip(progressClip);
                    GradientPaint progressGradient = new GradientPaint(0.0f, 0.0f, PROGRESS_START, progressWidth, 0.0f, PROGRESS_END);
                    g2d.setPaint(progressGradient);
                    g2d.fillRoundRect(1, 1, progressWidth, height - 2, arc - 2, arc - 2);
                    GradientPaint topShine = new GradientPaint(0.0f, 1.0f, new Color(255, 255, 255, 100), 0.0f, height / 2, new Color(255, 255, 255, 20));
                    g2d.setPaint(topShine);
                    g2d.fillRoundRect(1, 1, progressWidth, height / 2 - 1, arc - 2, arc - 2);
                    GradientPaint bottomShadow = new GradientPaint(0.0f, height / 2, new Color(0, 0, 0, 0), 0.0f, height - 1, new Color(0, 0, 0, 40));
                    g2d.setPaint(bottomShadow);
                    g2d.fillRoundRect(1, height / 2, progressWidth, height / 2 - 1, arc - 2, arc - 2);
                    if (progressWidth > 4) {
                        g2d.setClip(null);
                        g2d.setColor(new Color(51, 136, 255, 80));
                        g2d.setStroke(new BasicStroke(2.0f));
                        g2d.drawLine(progressWidth, 2, progressWidth, height - 2);
                    }
                }
                g2d.setClip(null);
                g2d.setColor(new Color(30, 33, 40));
                g2d.setStroke(new BasicStroke(1.0f));
                g2d.drawRoundRect(0, 0, width - 1, height - 1, arc, arc);
                g2d.dispose();
            }

            @Override
            protected void paintIndeterminate(Graphics g, JComponent c) {
                this.paintDeterminate(g, c);
            }
        });
    }
}

