/*
 * Decompiled with CFR 0.152.
 */
package com.cabal.launcher.ui;

import com.cabal.launcher.model.UpdateProgress;
import com.cabal.launcher.ui.BannerPanel;
import com.cabal.launcher.ui.GlassyProgressBar;
import com.cabal.launcher.ui.StyledButton;
import com.cabal.launcher.viewmodel.LauncherViewModel;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class LauncherFrame
extends JFrame {
    private static final Color BOTTOM_BAR_COLOR = new Color(22, 26, 32);
    private static final Color PRIMARY_BLUE = new Color(10, 97, 255);
    private static final Color BUTTON_HOVER = new Color(44, 50, 62);
    private static final int WINDOW_WIDTH = 1100;
    private static final int WINDOW_HEIGHT = 640;
    private static final int BANNER_HEIGHT = 560;
    private static final int BOTTOM_BAR_HEIGHT = 80;
    private final LauncherViewModel viewModel = new LauncherViewModel();
    private BannerPanel bannerPanel;
    private GlassyProgressBar progressBar;
    private JLabel statusLabel;
    private JLabel percentageLabel;
    private Point mouseDownPoint;
    private StyledButton startButton;

    public LauncherFrame() {
        this.initFrame();
        this.initComponents();
        this.bindViewModel();
        this.viewModel.checkForUpdates();
    }

    private void initFrame() {
        this.setTitle("CABAL MAX Launcher");
        this.setSize(1100, 640);
        this.setDefaultCloseOperation(3);
        this.setLocationRelativeTo(null);
        this.setUndecorated(true);
        this.setResizable(false);
        try {
            URL iconURL = this.getClass().getResource("/assets/images/icon.png");
            if (iconURL != null) {
                ImageIcon icon = new ImageIcon(iconURL);
                this.setIconImage(icon.getImage());
            }
        }
        catch (Exception e) {
            System.err.println("Could not load application icon: " + e.getMessage());
        }
        this.setBackground(new Color(0, 0, 0, 0));
        this.getContentPane().setBackground(new Color(0, 0, 0, 0));
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        JPanel topBar = this.createTopControlBar();
        this.add((Component)topBar, "North");
        this.bannerPanel = new BannerPanel();
        this.bannerPanel.setPreferredSize(new Dimension(1100, 560));
        this.add((Component)this.bannerPanel, "Center");
        this.bannerPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                LauncherFrame.this.mouseDownPoint = e.getPoint();
            }
        });
        this.bannerPanel.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                Point currentPoint = e.getLocationOnScreen();
                LauncherFrame.this.setLocation(currentPoint.x - LauncherFrame.this.mouseDownPoint.x, currentPoint.y - LauncherFrame.this.mouseDownPoint.y);
            }
        });
        JPanel bottomBar = this.createBottomBar();
        this.add((Component)bottomBar, "South");
    }

    private JPanel createTopControlBar() {
        JPanel topBar = new JPanel(new BorderLayout()){

            @Override
            protected void paintComponent(Graphics g) {
            }
        };
        topBar.setOpaque(false);
        topBar.setPreferredSize(new Dimension(1100, 35));
        JPanel wrapper = new JPanel(new FlowLayout(2, 8, 5));
        wrapper.setOpaque(false);
        JPanel controlsPanel = new JPanel(new FlowLayout(1, 5, 2)){

            @Override
            protected void paintComponent(Graphics g) {
                Graphics2D g2d = (Graphics2D)g.create();
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2d.setColor(new Color(15, 18, 23, 200));
                g2d.fillRoundRect(0, 0, this.getWidth(), this.getHeight(), 6, 6);
                g2d.dispose();
            }
        };
        controlsPanel.setOpaque(false);
        JButton minimizeBtn = this.createMinimizeButton();
        minimizeBtn.setPreferredSize(new Dimension(40, 30));
        minimizeBtn.setToolTipText("Minimize");
        minimizeBtn.addActionListener(e -> this.setState(1));
        JButton closeBtn = this.createCloseButton();
        closeBtn.setPreferredSize(new Dimension(40, 30));
        closeBtn.setToolTipText("Close");
        closeBtn.addActionListener(e -> {
            int confirm = JOptionPane.showConfirmDialog(this, "Are you sure you want to exit?", "Confirm Exit", 0);
            if (confirm == 0) {
                System.exit(0);
            }
        });
        controlsPanel.add(minimizeBtn);
        controlsPanel.add(closeBtn);
        wrapper.add(controlsPanel);
        topBar.add((Component)wrapper, "East");
        topBar.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                LauncherFrame.this.mouseDownPoint = e.getPoint();
            }
        });
        topBar.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                Point currentPoint = e.getLocationOnScreen();
                LauncherFrame.this.setLocation(currentPoint.x - LauncherFrame.this.mouseDownPoint.x, currentPoint.y - LauncherFrame.this.mouseDownPoint.y);
            }
        });
        return topBar;
    }

    private JButton createMinimizeButton() {
        final JButton btn = new JButton(){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                Graphics2D g2d = (Graphics2D)g.create();
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2d.setColor(Color.WHITE);
                g2d.setStroke(new BasicStroke(2.0f));
                int y = this.getHeight() / 2 + 3;
                g2d.drawLine(10, y, this.getWidth() - 10, y);
                g2d.dispose();
            }
        };
        btn.setFocusPainted(false);
        btn.setBorderPainted(false);
        btn.setContentAreaFilled(false);
        btn.setOpaque(false);
        btn.setCursor(new Cursor(12));
        btn.addMouseListener(new MouseAdapter(this){

            @Override
            public void mouseEntered(MouseEvent e) {
                btn.setBackground(BUTTON_HOVER);
                btn.setContentAreaFilled(true);
                btn.setOpaque(true);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                btn.setContentAreaFilled(false);
                btn.setOpaque(false);
            }
        });
        return btn;
    }

    private JButton createCloseButton() {
        final JButton btn = new JButton(){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                Graphics2D g2d = (Graphics2D)g.create();
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2d.setColor(Color.WHITE);
                g2d.setStroke(new BasicStroke(2.0f));
                int size = Math.min(this.getWidth(), this.getHeight()) - 16;
                int centerX = this.getWidth() / 2;
                int centerY = this.getHeight() / 2;
                int half = size / 2;
                g2d.drawLine(centerX - half, centerY - half, centerX + half, centerY + half);
                g2d.drawLine(centerX + half, centerY - half, centerX - half, centerY + half);
                g2d.dispose();
            }
        };
        btn.setFocusPainted(false);
        btn.setBorderPainted(false);
        btn.setContentAreaFilled(false);
        btn.setOpaque(false);
        btn.setCursor(new Cursor(12));
        btn.addMouseListener(new MouseAdapter(this){

            @Override
            public void mouseEntered(MouseEvent e) {
                btn.setBackground(new Color(200, 50, 50));
                btn.setContentAreaFilled(true);
                btn.setOpaque(true);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                btn.setContentAreaFilled(false);
                btn.setOpaque(false);
            }
        });
        return btn;
    }

    private JPanel createBottomBar() {
        JPanel bottomBar = new JPanel(new BorderLayout());
        bottomBar.setBackground(BOTTOM_BAR_COLOR);
        bottomBar.setPreferredSize(new Dimension(1100, 80));
        bottomBar.setBorder(BorderFactory.createEmptyBorder(8, 12, 8, 12));
        JPanel leftColumn = this.createPercentageColumn();
        bottomBar.add((Component)leftColumn, "West");
        JPanel centerColumn = this.createProgressColumn();
        bottomBar.add((Component)centerColumn, "Center");
        JPanel rightColumn = this.createAllButtonsSection();
        bottomBar.add((Component)rightColumn, "East");
        return bottomBar;
    }

    private JPanel createPercentageColumn() {
        JPanel panel = new JPanel(null);
        panel.setBackground(BOTTOM_BAR_COLOR);
        panel.setPreferredSize(new Dimension(100, 64));
        this.percentageLabel = new JLabel("25 %");
        this.percentageLabel.setForeground(PRIMARY_BLUE);
        this.percentageLabel.setFont(new Font("Arial", 1, 32));
        this.percentageLabel.setBounds(0, 12, 100, 40);
        this.percentageLabel.setHorizontalAlignment(0);
        panel.add(this.percentageLabel);
        return panel;
    }

    private JPanel createProgressColumn() {
        JPanel panel = new JPanel(null);
        panel.setBackground(BOTTOM_BAR_COLOR);
        this.statusLabel = new JLabel("Ready");
        this.statusLabel.setForeground(Color.WHITE);
        this.statusLabel.setFont(new Font("Arial", 0, 13));
        this.statusLabel.setBounds(10, 8, 600, 18);
        this.progressBar = new GlassyProgressBar(0, 100);
        this.progressBar.setValue(25);
        this.progressBar.setBounds(10, 38, 600, 14);
        this.progressBar.setVisible(true);
        panel.add(this.statusLabel);
        panel.add(this.progressBar);
        return panel;
    }

    private JPanel createAllButtonsSection() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBackground(BOTTOM_BAR_COLOR);
        JPanel topRow = new JPanel(new FlowLayout(1, 0, 0));
        topRow.setBackground(BOTTOM_BAR_COLOR);
        topRow.setAlignmentX(0.5f);
        this.startButton = new StyledButton("Start GAME", true);
        this.startButton.setPreferredSize(new Dimension(250, 65));
        this.startButton.setEnabled(false);
        this.startButton.addActionListener(e -> this.viewModel.startGame());
        topRow.add(this.startButton);
        panel.add(topRow);
        return panel;
    }

    private void bindViewModel() {
        this.viewModel.addPropertyChangeListener(evt -> {
            if ("updateProgress".equals(evt.getPropertyName())) {
                SwingUtilities.invokeLater(() -> {
                    UpdateProgress progress = this.viewModel.getUpdateProgress();
                    this.updateProgress(progress);
                });
            }
        });
    }

    private void updateProgress(UpdateProgress progress) {
        if (progress == null) {
            return;
        }
        String status = progress.getStatus();
        if (status != null) {
            String displayStatus = status;
            if (progress.getTotalFiles() > 0 && !status.contains("File:") && !status.contains("(")) {
                displayStatus = String.format("File %d/%d: %s", progress.getCurrentFileIndex(), progress.getTotalFiles(), status);
            }
            if (displayStatus.contains("Downloading")) {
                this.statusLabel.setText(displayStatus);
            } else if (displayStatus.contains("Completed")) {
                this.statusLabel.setText("Completed");
            } else if (displayStatus.contains("Verifying")) {
                this.statusLabel.setText("Verifying...");
            } else if (displayStatus.contains("Repairing")) {
                this.statusLabel.setText(displayStatus);
            } else {
                this.statusLabel.setText(displayStatus);
            }
        }
        int percent = progress.getPercentage();
        this.progressBar.setValue(percent);
        this.percentageLabel.setText(percent + " %");
        if (this.startButton != null) {
            this.startButton.setEnabled(progress.isCompleted());
        }
    }
}

