/*
 * Decompiled with CFR 0.152.
 */
package com.cabal.launcher.ui;

import com.cabal.launcher.model.NewsItem;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class NewsPanel
extends JPanel {
    private static final Color BG_COLOR = new Color(28, 31, 38);
    private static final Color PANEL_COLOR = new Color(35, 38, 45);
    private static final Color TEXT_COLOR = Color.WHITE;
    private static final Color MUTED_COLOR = new Color(168, 179, 199);
    private static final Color HOVER_COLOR = new Color(45, 48, 55);
    private static final Color GOLD_COLOR = new Color(218, 165, 32);

    public NewsPanel(List<NewsItem> newsItems) {
        this.setLayout(new BorderLayout());
        this.setBackground(BG_COLOR);
        JLabel titleLabel = new JLabel("NEWS & UPDATES");
        titleLabel.setForeground(GOLD_COLOR);
        titleLabel.setFont(new Font("Arial", 1, 14));
        titleLabel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.add((Component)titleLabel, "North");
        JPanel newsListPanel = new JPanel();
        newsListPanel.setLayout(new BoxLayout(newsListPanel, 1));
        newsListPanel.setBackground(BG_COLOR);
        for (NewsItem item : newsItems) {
            newsListPanel.add(this.createNewsItemPanel(item));
            newsListPanel.add(Box.createVerticalStrut(5));
        }
        JScrollPane scrollPane = new JScrollPane(newsListPanel);
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        scrollPane.setBackground(BG_COLOR);
        scrollPane.getViewport().setBackground(BG_COLOR);
        scrollPane.getVerticalScrollBar().setUnitIncrement(16);
        this.add((Component)scrollPane, "Center");
    }

    private JPanel createNewsItemPanel(final NewsItem item) {
        final JPanel panel = new JPanel(new BorderLayout(10, 5));
        panel.setBackground(PANEL_COLOR);
        panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(new Color(50, 53, 60), 1), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        panel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 80));
        panel.setCursor(new Cursor(12));
        JPanel textPanel = new JPanel();
        textPanel.setLayout(new BoxLayout(textPanel, 1));
        textPanel.setOpaque(false);
        JLabel titleLabel = new JLabel(item.getTitle());
        titleLabel.setForeground(TEXT_COLOR);
        titleLabel.setFont(new Font("Arial", 1, 12));
        textPanel.add(titleLabel);
        textPanel.add(Box.createVerticalStrut(3));
        JLabel descLabel = new JLabel("<html>" + this.truncate(item.getDescription(), 60) + "</html>");
        descLabel.setForeground(MUTED_COLOR);
        descLabel.setFont(new Font("Arial", 0, 10));
        textPanel.add(descLabel);
        textPanel.add(Box.createVerticalStrut(3));
        JLabel dateLabel = new JLabel(item.getDate());
        dateLabel.setForeground(MUTED_COLOR);
        dateLabel.setFont(new Font("Arial", 2, 9));
        textPanel.add(dateLabel);
        panel.add((Component)textPanel, "Center");
        panel.addMouseListener(new MouseAdapter(this){

            @Override
            public void mouseEntered(MouseEvent e) {
                panel.setBackground(HOVER_COLOR);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                panel.setBackground(PANEL_COLOR);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                JOptionPane.showMessageDialog(panel, "Opening: " + item.getUrl(), "News Link", 1);
            }
        });
        return panel;
    }

    private String truncate(String text, int maxLength) {
        if (text.length() <= maxLength) {
            return text;
        }
        return text.substring(0, maxLength) + "...";
    }
}

