/*
 * Decompiled with CFR 0.152.
 */
package com.cabal.launcher.ui;

import com.cabal.launcher.model.UpdateProgress;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class ProgressPanel
extends JPanel {
    private static final Color BG_COLOR = new Color(28, 31, 38);
    private static final Color TEXT_COLOR = Color.WHITE;
    private static final Color GOLD_COLOR = new Color(218, 165, 32);
    private static final Color PROGRESS_BG = new Color(60, 63, 70);
    private static final Color PROGRESS_FG = new Color(0, 102, 255);
    private final JProgressBar progressBar;
    private final JLabel statusLabel;
    private final JLabel sizeLabel;
    private final JLabel fileCountLabel;

    public ProgressPanel() {
        this.setLayout(new BorderLayout(10, 5));
        this.setBackground(BG_COLOR);
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel topPanel = new JPanel(new BorderLayout(5, 0));
        topPanel.setBackground(BG_COLOR);
        this.statusLabel = new JLabel("Ready");
        this.statusLabel.setForeground(GOLD_COLOR);
        this.statusLabel.setFont(new Font("Arial", 1, 12));
        topPanel.add((Component)this.statusLabel, "West");
        this.fileCountLabel = new JLabel("");
        this.fileCountLabel.setForeground(TEXT_COLOR);
        this.fileCountLabel.setFont(new Font("Arial", 0, 11));
        this.fileCountLabel.setHorizontalAlignment(4);
        topPanel.add((Component)this.fileCountLabel, "East");
        this.add((Component)topPanel, "North");
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setValue(0);
        this.progressBar.setStringPainted(true);
        this.progressBar.setForeground(PROGRESS_FG);
        this.progressBar.setBackground(PROGRESS_BG);
        this.progressBar.setBorderPainted(false);
        this.progressBar.setPreferredSize(new Dimension(0, 25));
        this.progressBar.setFont(new Font("Arial", 1, 11));
        this.add((Component)this.progressBar, "Center");
        this.sizeLabel = new JLabel("0.00 GB / 0.00 GB");
        this.sizeLabel.setForeground(TEXT_COLOR);
        this.sizeLabel.setFont(new Font("Arial", 0, 11));
        this.add((Component)this.sizeLabel, "South");
    }

    public void updateProgress(UpdateProgress progress) {
        SwingUtilities.invokeLater(() -> {
            this.progressBar.setValue(progress.getPercentage());
            this.progressBar.setString(progress.getPercentage() + "%");
            this.statusLabel.setText(progress.getStatus());
            this.sizeLabel.setText(progress.getCurrentSizeFormatted() + " / " + progress.getTotalSizeFormatted());
            if (progress.getTotalFiles() > 0) {
                this.fileCountLabel.setText("File: " + progress.getCurrentFileIndex() + " / " + progress.getTotalFiles());
            } else {
                this.fileCountLabel.setText("");
            }
            if (progress.isCompleted()) {
                this.statusLabel.setForeground(Color.GREEN);
            } else {
                this.statusLabel.setForeground(GOLD_COLOR);
            }
        });
    }
}

