/*
 * Decompiled with CFR 0.152.
 */
package com.cabal.launcher.ui;

import com.cabal.launcher.model.Settings;
import com.cabal.launcher.ui.StyledButton;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SettingsDialog
extends JDialog {
    private static final Color BG_COLOR = new Color(28, 31, 38);
    private static final Color PANEL_COLOR = new Color(35, 38, 45);
    private static final Color TEXT_COLOR = Color.WHITE;
    private static final Color GOLD_COLOR = new Color(218, 165, 32);
    private final Settings settings;
    private JComboBox<String> resolutionCombo;
    private JComboBox<String> languageCombo;
    private JComboBox<String> serverCombo;
    private JCheckBox fullscreenCheck;
    private boolean saved = false;

    public SettingsDialog(JFrame parent, Settings settings) {
        super(parent, "Settings", true);
        this.settings = settings;
        this.setSize(500, 400);
        this.setLocationRelativeTo(parent);
        this.setResizable(false);
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.getContentPane().setBackground(BG_COLOR);
        JPanel titlePanel = new JPanel(new BorderLayout());
        titlePanel.setBackground(PANEL_COLOR);
        titlePanel.setBorder(BorderFactory.createEmptyBorder(15, 20, 15, 20));
        JLabel titleLabel = new JLabel("Launcher Settings");
        titleLabel.setForeground(GOLD_COLOR);
        titleLabel.setFont(new Font("Arial", 1, 18));
        titlePanel.add((Component)titleLabel, "West");
        this.add((Component)titlePanel, "North");
        JPanel settingsPanel = new JPanel();
        settingsPanel.setLayout(new BoxLayout(settingsPanel, 1));
        settingsPanel.setBackground(BG_COLOR);
        settingsPanel.setBorder(BorderFactory.createEmptyBorder(20, 30, 20, 30));
        this.resolutionCombo = this.createComboBox(new String[]{"1920x1080", "1680x1050", "1600x900", "1440x900", "1366x768", "1280x720", "2560x1440", "3840x2160"}, this.settings.getResolution());
        settingsPanel.add(this.createSettingRow("Resolution:", this.resolutionCombo));
        settingsPanel.add(Box.createVerticalStrut(15));
        this.languageCombo = this.createComboBox(new String[]{"English", "Spanish", "French", "German", "Portuguese", "Russian", "Korean", "Japanese"}, this.settings.getLanguage());
        settingsPanel.add(this.createSettingRow("Language:", this.languageCombo));
        settingsPanel.add(Box.createVerticalStrut(15));
        this.serverCombo = this.createComboBox(new String[]{"North America", "Europe", "Asia", "South America"}, this.settings.getServer());
        settingsPanel.add(this.createSettingRow("Server:", this.serverCombo));
        settingsPanel.add(Box.createVerticalStrut(15));
        JPanel fullscreenPanel = new JPanel(new FlowLayout(0, 0, 0));
        fullscreenPanel.setOpaque(false);
        this.fullscreenCheck = new JCheckBox("Fullscreen Mode");
        this.fullscreenCheck.setSelected(this.settings.isFullscreen());
        this.fullscreenCheck.setForeground(TEXT_COLOR);
        this.fullscreenCheck.setBackground(BG_COLOR);
        this.fullscreenCheck.setFont(new Font("Arial", 0, 13));
        this.fullscreenCheck.setFocusPainted(false);
        fullscreenPanel.add(this.fullscreenCheck);
        settingsPanel.add(fullscreenPanel);
        this.add((Component)settingsPanel, "Center");
        JPanel buttonPanel = new JPanel(new FlowLayout(2, 10, 10));
        buttonPanel.setBackground(BG_COLOR);
        StyledButton saveBtn = new StyledButton("Save", true);
        saveBtn.addActionListener(e -> {
            this.saveSettings();
            this.saved = true;
            this.dispose();
        });
        StyledButton cancelBtn = new StyledButton("Cancel", false);
        cancelBtn.addActionListener(e -> this.dispose());
        buttonPanel.add(saveBtn);
        buttonPanel.add(cancelBtn);
        this.add((Component)buttonPanel, "South");
    }

    private JPanel createSettingRow(String labelText, JComponent component) {
        JPanel panel = new JPanel(new BorderLayout(10, 0));
        panel.setOpaque(false);
        panel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 35));
        JLabel label = new JLabel(labelText);
        label.setForeground(TEXT_COLOR);
        label.setFont(new Font("Arial", 1, 13));
        label.setPreferredSize(new Dimension(120, 30));
        panel.add((Component)label, "West");
        panel.add((Component)component, "Center");
        return panel;
    }

    private JComboBox<String> createComboBox(String[] items, String selectedItem) {
        JComboBox<String> combo = new JComboBox<String>(items);
        combo.setSelectedItem(selectedItem);
        combo.setBackground(PANEL_COLOR);
        combo.setForeground(TEXT_COLOR);
        combo.setFont(new Font("Arial", 0, 12));
        combo.setFocusable(false);
        return combo;
    }

    private void saveSettings() {
        this.settings.setResolution((String)this.resolutionCombo.getSelectedItem());
        this.settings.setLanguage((String)this.languageCombo.getSelectedItem());
        this.settings.setServer((String)this.serverCombo.getSelectedItem());
        this.settings.setFullscreen(this.fullscreenCheck.isSelected());
    }

    public boolean isSaved() {
        return this.saved;
    }
}

