/*
 * Decompiled with CFR 0.152.
 */
package com.cabal.launcher.ui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.plaf.basic.BasicButtonUI;

public class StyledButton
extends JButton {
    private static final Color PRIMARY_COLOR = new Color(10, 97, 255);
    private static final Color PRIMARY_HOVER = new Color(51, 136, 255);
    private static final Color SECONDARY_COLOR = new Color(60, 63, 70);
    private static final Color SECONDARY_HOVER = new Color(80, 83, 90);
    private static final Color DISABLED_COLOR = new Color(40, 43, 50);
    private static final Color TEXT_COLOR = Color.WHITE;
    private static final Color DISABLED_TEXT_COLOR = new Color(100, 100, 100);
    private final boolean isPrimary;
    private Color normalColor;
    private Color hoverColor;
    private boolean isHovered = false;

    public StyledButton(String text, boolean isPrimary) {
        super(text);
        this.isPrimary = isPrimary;
        if (isPrimary) {
            this.normalColor = PRIMARY_COLOR;
            this.hoverColor = PRIMARY_HOVER;
        } else {
            this.normalColor = SECONDARY_COLOR;
            this.hoverColor = SECONDARY_HOVER;
        }
        this.setupButton();
    }

    public StyledButton(String text) {
        this(text, false);
    }

    private void setupButton() {
        this.setForeground(this.isPrimary ? Color.BLACK : TEXT_COLOR);
        this.setBackground(this.normalColor);
        this.setFont(new Font("Arial", 1, 20));
        this.setFocusPainted(false);
        this.setBorderPainted(false);
        this.setCursor(new Cursor(12));
        this.setPreferredSize(new Dimension(120, 80));
        if (this.isPrimary) {
            this.setContentAreaFilled(false);
            this.setOpaque(false);
            this.setBorder(BorderFactory.createEmptyBorder(5, 15, 5, 15));
            this.setUI(new BasicButtonUI(){

                @Override
                public void paint(Graphics g, JComponent c) {
                    JButton btn = (JButton)c;
                    Graphics2D g2d = (Graphics2D)g.create();
                    g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                    g2d.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
                    int width = btn.getWidth();
                    int height = btn.getHeight();
                    int arc = 12;
                    int inset = 1;
                    Color gold = new Color(251, 191, 36);
                    Color orange = new Color(245, 158, 11);
                    if (StyledButton.this.isHovered && StyledButton.this.isEnabled()) {
                        for (int i = 6; i > 0; --i) {
                            float alpha = (float)(6 - i) * 0.03f;
                            g2d.setColor(new Color(255, 255, 255, (int)(alpha * 255.0f)));
                            int glowInset = i + inset;
                            g2d.drawRoundRect(glowInset, glowInset, width - glowInset * 2 - 1, height - glowInset * 2 - 1, arc + 2, arc + 2);
                        }
                        GradientPaint hoverGradient = new GradientPaint(0.0f, 0.0f, new Color(255, 215, 70), width - inset * 2, height - inset * 2, new Color(255, 180, 50));
                        g2d.setPaint(hoverGradient);
                        g2d.fillRoundRect(inset, inset, width - inset * 2, height - inset * 2, arc, arc);
                    } else {
                        GradientPaint gradient = new GradientPaint(0.0f, 0.0f, gold, width - inset * 2, height - inset * 2, orange);
                        g2d.setPaint(gradient);
                        g2d.fillRoundRect(inset, inset, width - inset * 2, height - inset * 2, arc, arc);
                    }
                    GradientPaint topShine = new GradientPaint(0.0f, inset, new Color(255, 255, 255, StyledButton.this.isHovered ? 120 : 70), 0.0f, height / 2, new Color(255, 255, 255, 0));
                    g2d.setPaint(topShine);
                    g2d.fillRoundRect(inset, inset, width - inset * 2, height / 2 - inset, arc, arc);
                    GradientPaint bottomShadow = new GradientPaint(0.0f, height / 2, new Color(0, 0, 0, 0), 0.0f, height - inset, new Color(0, 0, 0, StyledButton.this.isHovered ? 50 : 30));
                    g2d.setPaint(bottomShadow);
                    g2d.fillRoundRect(inset, height / 2, width - inset * 2, height / 2 - inset, arc, arc);
                    if (StyledButton.this.isHovered && StyledButton.this.isEnabled()) {
                        g2d.setColor(new Color(255, 255, 255, 150));
                        g2d.setStroke(new BasicStroke(2.0f));
                        g2d.drawRoundRect(inset + 2, inset + 2, width - inset * 2 - 4, height - inset * 2 - 4, arc - 2, arc - 2);
                    }
                    g2d.dispose();
                    super.paint(g, c);
                }
            });
        } else {
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(this.normalColor.darker(), 1), BorderFactory.createEmptyBorder(5, 15, 5, 15)));
        }
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (StyledButton.this.isEnabled()) {
                    StyledButton.this.isHovered = true;
                    if (StyledButton.this.isPrimary) {
                        StyledButton.this.setForeground(Color.WHITE);
                    } else {
                        StyledButton.this.setBackground(StyledButton.this.hoverColor);
                        StyledButton.this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(StyledButton.this.hoverColor.darker(), 1), BorderFactory.createEmptyBorder(5, 15, 5, 15)));
                    }
                    StyledButton.this.repaint();
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                StyledButton.this.isHovered = false;
                if (StyledButton.this.isPrimary) {
                    StyledButton.this.setForeground(Color.BLACK);
                } else {
                    StyledButton.this.setBackground(StyledButton.this.normalColor);
                    StyledButton.this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(StyledButton.this.normalColor.darker(), 1), BorderFactory.createEmptyBorder(5, 15, 5, 15)));
                }
                StyledButton.this.repaint();
            }
        });
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (!enabled) {
            this.setBackground(DISABLED_COLOR);
            this.setForeground(DISABLED_TEXT_COLOR);
            this.setCursor(new Cursor(0));
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(DISABLED_COLOR.darker(), 1), BorderFactory.createEmptyBorder(5, 15, 5, 15)));
        } else {
            this.setBackground(this.normalColor);
            this.setForeground(TEXT_COLOR);
            this.setCursor(new Cursor(12));
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(this.normalColor.darker(), 1), BorderFactory.createEmptyBorder(5, 15, 5, 15)));
        }
    }
}

