/*
 * Decompiled with CFR 0.152.
 */
package com.cabal.launcher.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class FileVerifier {
    public static String calculateSHA256(File file) throws IOException {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            try (FileInputStream fis = new FileInputStream(file);){
                int bytesRead;
                byte[] buffer = new byte[8192];
                while ((bytesRead = fis.read(buffer)) != -1) {
                    digest.update(buffer, 0, bytesRead);
                }
            }
            return FileVerifier.bytesToHex(digest.digest());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("SHA-256 algorithm not available", e);
        }
    }

    public static boolean verifyFile(File file, String expectedHash) {
        if (!file.exists()) {
            return false;
        }
        try {
            String actualHash = FileVerifier.calculateSHA256(file);
            return actualHash.equalsIgnoreCase(expectedHash);
        }
        catch (IOException e) {
            return false;
        }
    }

    public static void atomicReplace(Path tempFile, Path targetFile) throws IOException {
        if (targetFile.getParent() != null) {
            Files.createDirectories(targetFile.getParent(), new FileAttribute[0]);
        }
        int maxRetries = 3;
        int retryDelay = 100;
        IOException lastException = null;
        for (int attempt = 1; attempt <= maxRetries; ++attempt) {
            try {
                File targetFileObj;
                if (Files.exists(targetFile, new LinkOption[0]) && !(targetFileObj = targetFile.toFile()).canWrite()) {
                    System.out.println("[DEBUG] Removing read-only flag from: " + String.valueOf(targetFile));
                    targetFileObj.setWritable(true);
                }
                try {
                    Files.move(tempFile, targetFile, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
                    System.out.println("[DEBUG] Atomic move successful on attempt " + attempt);
                    return;
                }
                catch (Exception e1) {
                    System.out.println("[DEBUG] Atomic move failed (attempt " + attempt + "): " + e1.getMessage());
                    try {
                        Files.move(tempFile, targetFile, StandardCopyOption.REPLACE_EXISTING);
                        System.out.println("[DEBUG] Regular move successful on attempt " + attempt);
                        return;
                    }
                    catch (Exception e2) {
                        System.out.println("[DEBUG] Regular move failed (attempt " + attempt + "): " + e2.getMessage());
                        Files.copy(tempFile, targetFile, StandardCopyOption.REPLACE_EXISTING);
                        Files.deleteIfExists(tempFile);
                        System.out.println("[DEBUG] Copy+delete successful on attempt " + attempt);
                        return;
                    }
                }
            }
            catch (IOException e) {
                lastException = e;
                System.err.println("[ERROR] Attempt " + attempt + " failed: " + e.getMessage());
                if (attempt >= maxRetries) continue;
                System.out.println("[DEBUG] Waiting " + retryDelay + "ms before retry...");
                try {
                    Thread.sleep(retryDelay);
                    retryDelay *= 2;
                    continue;
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    throw new IOException("Interrupted during retry", ie);
                }
            }
        }
        throw new IOException("Failed to replace file after " + maxRetries + " attempts: " + String.valueOf(targetFile) + " - " + (lastException != null ? lastException.getMessage() : "Unknown error"), lastException);
    }

    private static String bytesToHex(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }
}

