/*
 * Decompiled with CFR 0.152.
 */
package com.cabal.launcher.util;

import com.cabal.launcher.model.Manifest;
import com.cabal.launcher.model.ManifestEntry;
import com.cabal.launcher.model.Settings;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class JsonUtil {
    public static Settings loadSettings(File file) {
        Settings settings = new Settings();
        if (!file.exists()) {
            return settings;
        }
        try {
            String content = JsonUtil.readFileContent(file);
            JSONObject json = new JSONObject(content);
            settings.setResolution(json.optString("resolution", "1920x1080"));
            settings.setLanguage(json.optString("language", "English"));
            settings.setServer(json.optString("server", "North America"));
            settings.setFullscreen(json.optBoolean("fullscreen", true));
        }
        catch (Exception e) {
            System.err.println("Error loading settings: " + e.getMessage());
        }
        return settings;
    }

    public static void saveSettings(Settings settings, File file) {
        try {
            JSONObject json = new JSONObject();
            json.put("resolution", settings.getResolution());
            json.put("language", settings.getLanguage());
            json.put("server", settings.getServer());
            json.put("fullscreen", settings.isFullscreen());
            file.getParentFile().mkdirs();
            JsonUtil.writeFileContent(file, json.toString(2));
        }
        catch (Exception e) {
            System.err.println("Error saving settings: " + e.getMessage());
        }
    }

    public static Manifest loadManifestWithVersion(File file) {
        Manifest manifest = new Manifest();
        manifest.setVersion("0");
        manifest.setFiles(new ArrayList<ManifestEntry>());
        if (!file.exists()) {
            return manifest;
        }
        try {
            String content = JsonUtil.readFileContent(file);
            JSONObject json = new JSONObject(content);
            String version = json.has("version") ? json.getString("version") : (json.has("lastUpdate") ? String.valueOf(json.getLong("lastUpdate")) : "0");
            manifest.setVersion(version);
            manifest.setTimestamp(json.optString("lastUpdate", json.optString("timestamp", "")));
            manifest.setDescription(json.optString("description", ""));
            ArrayList<ManifestEntry> entries = new ArrayList<ManifestEntry>();
            JSONArray files = json.optJSONArray("files");
            if (files != null) {
                for (int i = 0; i < files.length(); ++i) {
                    JSONObject fileObj = files.getJSONObject(i);
                    ManifestEntry entry = new ManifestEntry(fileObj.getString("path"), fileObj.getString("hash"), fileObj.getLong("size"));
                    entries.add(entry);
                }
            }
            manifest.setFiles(entries);
        }
        catch (Exception e) {
            System.err.println("Error loading manifest: " + e.getMessage());
            e.printStackTrace();
        }
        return manifest;
    }

    public static List<ManifestEntry> loadManifest(File file) {
        ArrayList<ManifestEntry> entries = new ArrayList<ManifestEntry>();
        if (!file.exists()) {
            return entries;
        }
        try {
            String content = JsonUtil.readFileContent(file);
            JSONObject json = new JSONObject(content);
            JSONArray files = json.getJSONArray("files");
            for (int i = 0; i < files.length(); ++i) {
                JSONObject fileObj = files.getJSONObject(i);
                ManifestEntry entry = new ManifestEntry(fileObj.getString("path"), fileObj.getString("hash"), fileObj.getLong("size"));
                entries.add(entry);
            }
        }
        catch (Exception e) {
            System.err.println("Error loading manifest: " + e.getMessage());
        }
        return entries;
    }

    private static String readFileContent(File file) throws IOException {
        StringBuilder content = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            String line;
            while ((line = reader.readLine()) != null) {
                content.append(line).append("\n");
            }
        }
        return content.toString();
    }

    private static void writeFileContent(File file, String content) throws IOException {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
            writer.write(content);
        }
    }
}

