/*
 * Decompiled with CFR 0.152.
 */
package com.cabal.launcher.viewmodel;

import com.cabal.launcher.model.ManifestEntry;
import com.cabal.launcher.model.NewsItem;
import com.cabal.launcher.model.Settings;
import com.cabal.launcher.model.UpdateProgress;
import com.cabal.launcher.service.UpdateManager;
import com.cabal.launcher.util.JsonUtil;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.Timer;

public class LauncherViewModel {
    private final PropertyChangeSupport support = new PropertyChangeSupport(this);
    private final UpdateManager updateManager = new UpdateManager();
    private UpdateProgress updateProgress = new UpdateProgress();
    private Settings settings = JsonUtil.loadSettings(SETTINGS_FILE);
    private List<NewsItem> newsItems = this.createDummyNews();
    private int currentBannerIndex = 0;
    private static final File SETTINGS_FILE = new File("./settings.json");

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    public UpdateProgress getUpdateProgress() {
        return this.updateProgress;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public List<NewsItem> getNewsItems() {
        return this.newsItems;
    }

    public int getCurrentBannerIndex() {
        return this.currentBannerIndex;
    }

    public void setCurrentBannerIndex(int index) {
        int oldValue = this.currentBannerIndex;
        this.currentBannerIndex = index;
        this.support.firePropertyChange("currentBannerIndex", oldValue, index);
    }

    public void saveSettings() {
        JsonUtil.saveSettings(this.settings, SETTINGS_FILE);
    }

    public void startGame() {
        SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                try {
                    ProcessBuilder pb = new ProcessBuilder("cmd.exe", "/c", "start", "CabalMain.exe", "husky");
                    pb.directory(new File("."));
                    Process process = pb.start();
                    Thread.sleep(1000L);
                    if (process.isAlive() || !process.info().command().isPresent()) {
                        SwingUtilities.invokeLater(() -> {
                            LauncherViewModel.this.updateProgress.setStatus("Game started - Closing launcher");
                            LauncherViewModel.this.support.firePropertyChange("updateProgress", null, LauncherViewModel.this.updateProgress);
                            Timer closeTimer = new Timer(500, e -> System.exit(0));
                            closeTimer.setRepeats(false);
                            closeTimer.start();
                        });
                    }
                }
                catch (IOException | InterruptedException e) {
                    SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(null, "Failed to start game: " + e.getMessage(), "Error", 0));
                }
                return null;
            }
        };
        worker.execute();
    }

    public void repair() {
        this.updateProgress.setCompleted(false);
        this.updateProgress.setStatus("Repairing files...");
        this.updateProgress.setTotalFiles(0);
        this.updateProgress.setCurrentFileIndex(0);
        this.support.firePropertyChange("updateProgress", null, this.updateProgress);
        this.updateManager.repair(progress -> SwingUtilities.invokeLater(() -> {
            this.updateProgress.setPercentage((int)progress);
            this.support.firePropertyChange("updateProgress", null, this.updateProgress);
        }), status -> SwingUtilities.invokeLater(() -> {
            this.updateProgress.setStatus((String)status);
            if (status.contains("completed")) {
                this.updateProgress.setCompleted(true);
                this.updateProgress.setPercentage(100);
            }
            this.support.firePropertyChange("updateProgress", null, this.updateProgress);
        }), (currentFileIndex, totalFiles, fileName) -> SwingUtilities.invokeLater(() -> {
            this.updateProgress.setCurrentFileIndex(currentFileIndex);
            this.updateProgress.setTotalFiles(totalFiles);
            this.updateProgress.setCurrentFileName(fileName);
            this.support.firePropertyChange("updateProgress", null, this.updateProgress);
        }));
    }

    public void checkForUpdates() {
        SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                try {
                    SwingUtilities.invokeLater(() -> {
                        LauncherViewModel.this.updateProgress.setStatus("Checking for updates...");
                        LauncherViewModel.this.updateProgress.setPercentage(0);
                        LauncherViewModel.this.updateProgress.setCompleted(false);
                        LauncherViewModel.this.updateProgress.setTotalFiles(0);
                        LauncherViewModel.this.updateProgress.setCurrentFileIndex(0);
                        LauncherViewModel.this.support.firePropertyChange("updateProgress", null, LauncherViewModel.this.updateProgress);
                    });
                    List<ManifestEntry> filesToUpdate = LauncherViewModel.this.updateManager.checkForUpdates(progress -> SwingUtilities.invokeLater(() -> {
                        LauncherViewModel.this.updateProgress.setPercentage((int)progress);
                        LauncherViewModel.this.support.firePropertyChange("updateProgress", null, LauncherViewModel.this.updateProgress);
                    }), status -> SwingUtilities.invokeLater(() -> {
                        LauncherViewModel.this.updateProgress.setStatus((String)status);
                        LauncherViewModel.this.support.firePropertyChange("updateProgress", null, LauncherViewModel.this.updateProgress);
                    }), (currentFileIndex, totalFiles, fileName) -> SwingUtilities.invokeLater(() -> {
                        LauncherViewModel.this.updateProgress.setCurrentFileIndex(currentFileIndex);
                        LauncherViewModel.this.updateProgress.setTotalFiles(totalFiles);
                        LauncherViewModel.this.updateProgress.setCurrentFileName(fileName);
                        LauncherViewModel.this.support.firePropertyChange("updateProgress", null, LauncherViewModel.this.updateProgress);
                    }));
                    if (!filesToUpdate.isEmpty()) {
                        SwingUtilities.invokeLater(() -> {
                            LauncherViewModel.this.updateProgress.setStatus("Starting download...");
                            LauncherViewModel.this.updateProgress.setPercentage(0);
                            LauncherViewModel.this.support.firePropertyChange("updateProgress", null, LauncherViewModel.this.updateProgress);
                        });
                        LauncherViewModel.this.updateManager.downloadFiles(filesToUpdate, progress -> SwingUtilities.invokeLater(() -> {
                            LauncherViewModel.this.updateProgress.setPercentage((int)progress);
                            LauncherViewModel.this.support.firePropertyChange("updateProgress", null, LauncherViewModel.this.updateProgress);
                        }), status -> SwingUtilities.invokeLater(() -> {
                            LauncherViewModel.this.updateProgress.setStatus((String)status);
                            if (status.contains("completed successfully")) {
                                LauncherViewModel.this.updateProgress.setCompleted(true);
                                LauncherViewModel.this.updateProgress.setPercentage(100);
                            }
                            LauncherViewModel.this.support.firePropertyChange("updateProgress", null, LauncherViewModel.this.updateProgress);
                        }), totalBytes -> SwingUtilities.invokeLater(() -> {
                            LauncherViewModel.this.updateProgress.setTotalBytes((long)totalBytes);
                            LauncherViewModel.this.support.firePropertyChange("updateProgress", null, LauncherViewModel.this.updateProgress);
                        }), (currentFileIndex, totalFiles, fileName) -> SwingUtilities.invokeLater(() -> {
                            LauncherViewModel.this.updateProgress.setCurrentFileIndex(currentFileIndex);
                            LauncherViewModel.this.updateProgress.setTotalFiles(totalFiles);
                            LauncherViewModel.this.updateProgress.setCurrentFileName(fileName);
                            LauncherViewModel.this.support.firePropertyChange("updateProgress", null, LauncherViewModel.this.updateProgress);
                        }), () -> {
                            System.out.println("[DEBUG] ========================================");
                            System.out.println("[DEBUG] SUCCESS CALLBACK TRIGGERED");
                            System.out.println("[DEBUG] ========================================");
                            SwingUtilities.invokeLater(() -> {
                                try {
                                    File tempManifest = new File("manifest_temp.json");
                                    File localManifest = new File("manifest.json");
                                    System.out.println("[DEBUG] Temp manifest exists: " + tempManifest.exists());
                                    System.out.println("[DEBUG] Temp manifest path: " + tempManifest.getAbsolutePath());
                                    System.out.println("[DEBUG] Local manifest path: " + localManifest.getAbsolutePath());
                                    if (tempManifest.exists()) {
                                        System.out.println("[DEBUG] Copying temp manifest to local manifest...");
                                        Files.copy(tempManifest.toPath(), localManifest.toPath(), StandardCopyOption.REPLACE_EXISTING);
                                        System.out.println("[DEBUG] Manifest updated successfully!");
                                        boolean deleted = tempManifest.delete();
                                        System.out.println("[DEBUG] Temp manifest deleted: " + deleted);
                                    } else {
                                        System.err.println("[ERROR] Temp manifest doesn't exist!");
                                    }
                                }
                                catch (Exception e) {
                                    System.err.println("[ERROR] Failed to update manifest: " + e.getMessage());
                                    e.printStackTrace();
                                }
                            });
                        });
                    } else {
                        File tempManifest = new File("manifest_temp.json");
                        if (tempManifest.exists()) {
                            tempManifest.delete();
                        }
                        SwingUtilities.invokeLater(() -> {
                            LauncherViewModel.this.updateProgress.setCompleted(true);
                            LauncherViewModel.this.updateProgress.setPercentage(100);
                            LauncherViewModel.this.support.firePropertyChange("updateProgress", null, LauncherViewModel.this.updateProgress);
                        });
                    }
                }
                catch (Exception e) {
                    File tempManifest = new File("./manifest_temp.json");
                    if (tempManifest.exists()) {
                        tempManifest.delete();
                    }
                    SwingUtilities.invokeLater(() -> {
                        LauncherViewModel.this.updateProgress.setStatus("Update failed: " + e.getMessage());
                        LauncherViewModel.this.updateProgress.setCompleted(false);
                        LauncherViewModel.this.support.firePropertyChange("updateProgress", null, LauncherViewModel.this.updateProgress);
                    });
                    e.printStackTrace();
                }
                return null;
            }
        };
        worker.execute();
    }

    private List<NewsItem> createDummyNews() {
        ArrayList<NewsItem> items = new ArrayList<NewsItem>();
        items.add(new NewsItem("Major Update v2.5 Released!", "New dungeon, raid content, and class balance changes.", "https://example.com/news/1", "/assets/images/news1.jpg", "2025-10-14"));
        items.add(new NewsItem("Halloween Event Starting Soon", "Participate in special events for exclusive rewards.", "https://example.com/news/2", "/assets/images/news2.jpg", "2025-10-13"));
        items.add(new NewsItem("Server Maintenance Schedule", "Scheduled maintenance on October 16th, 2AM - 6AM PST.", "https://example.com/news/3", "/assets/images/news3.jpg", "2025-10-12"));
        items.add(new NewsItem("New Character Customization", "Enhanced character creation with more options.", "https://example.com/news/4", "/assets/images/news4.jpg", "2025-10-11"));
        return items;
    }
}

